/*
 * Decompiled with CFR 0.152.
 */
package org.pierre.remotedroid.server.tools;

import java.util.HashMap;

public class UnicodeToSwingKeyCodeConverter {
    public static final int NO_SWING_KEYCODE = -1;
    private static HashMap<Integer, Integer> map;
    private static final int[][] othersArray;

    static {
        othersArray = new int[][]{{10, 10}, {-1, 8}, {32, 32}, {92, 33}, {93, 34}};
        map = new HashMap();
        UnicodeToSwingKeyCodeConverter.initMap();
    }

    public static int convert(int unicode) {
        Integer i = map.get(unicode);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public static boolean useShift(int unicode) {
        return unicode >= 65 && unicode <= 90 || unicode >= 48 && unicode <= 57;
    }

    private static void initMap() {
        UnicodeToSwingKeyCodeConverter.initIntervals();
        UnicodeToSwingKeyCodeConverter.initOthers();
    }

    private static void initIntervals() {
        UnicodeToSwingKeyCodeConverter.initInterval(97, 122, 65);
        UnicodeToSwingKeyCodeConverter.initInterval(65, 90, 65);
        UnicodeToSwingKeyCodeConverter.initInterval(48, 57, 48);
    }

    private static void initInterval(int unicodeStart, int unicodeStop, int swingKeyCodeStart) {
        int shift = swingKeyCodeStart - unicodeStart;
        int i = unicodeStart;
        while (i <= unicodeStop) {
            map.put(i, i + shift);
            ++i;
        }
    }

    private static void initOthers() {
        int i = 0;
        while (i < othersArray.length) {
            map.put(othersArray[i][0], othersArray[i][1]);
            ++i;
        }
    }
}

