/*
 * Decompiled with CFR 0.152.
 */
package org.pierre.remotedroid.server.connection;

import java.awt.Desktop;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ProtocolException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.pierre.remotedroid.protocol.PRemoteDroidConnection;
import org.pierre.remotedroid.protocol.action.AuthentificationAction;
import org.pierre.remotedroid.protocol.action.AuthentificationResponseAction;
import org.pierre.remotedroid.protocol.action.FileExploreRequestAction;
import org.pierre.remotedroid.protocol.action.FileExploreResponseAction;
import org.pierre.remotedroid.protocol.action.KeyboardAction;
import org.pierre.remotedroid.protocol.action.MouseClickAction;
import org.pierre.remotedroid.protocol.action.MouseMoveAction;
import org.pierre.remotedroid.protocol.action.MouseWheelAction;
import org.pierre.remotedroid.protocol.action.PRemoteDroidAction;
import org.pierre.remotedroid.protocol.action.ScreenCaptureRequestAction;
import org.pierre.remotedroid.protocol.action.ScreenCaptureResponseAction;
import org.pierre.remotedroid.server.PRemoteDroidServerApp;
import org.pierre.remotedroid.server.tools.UnicodeToSwingKeyCodeConverter;

public class PRemoteDroidServerConnection
implements Runnable {
    private static final int[][] UNICODE_EXCEPTION = new int[][]{{-1, 8}, {10, 10}, {2, 34}, {1, 33}, {9, 9}, {20, 40}, {19, 38}, {21, 37}, {22, 39}};
    private PRemoteDroidServerApp application;
    private PRemoteDroidConnection connection;
    private boolean authentificated;
    private boolean useUnicodeWindowsAltTrick;

    public PRemoteDroidServerConnection(PRemoteDroidServerApp application, PRemoteDroidConnection connection) {
        this.application = application;
        this.connection = connection;
        this.authentificated = false;
        this.useUnicodeWindowsAltTrick = PRemoteDroidServerApp.IS_WINDOWS && !this.application.getPreferences().getBoolean("force_disable_unicode_windows_alt_trick", false);
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            try {
                try {
                    while (true) {
                        PRemoteDroidAction action = this.connection.receiveAction();
                        this.action(action);
                    }
                }
                catch (IOException e) {
                    this.application.getTrayIcon().notifyConnection(this.connection);
                    this.connection.close();
                }
            }
            catch (Throwable throwable) {
                this.connection.close();
                throw throwable;
            }
        }
        catch (ProtocolException e) {
            e.printStackTrace();
            this.application.getTrayIcon().notifyProtocolProblem();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void action(PRemoteDroidAction action) {
        if (this.authentificated) {
            if (action instanceof MouseMoveAction) {
                this.moveMouse((MouseMoveAction)action);
            } else if (action instanceof MouseClickAction) {
                this.mouseClick((MouseClickAction)action);
            } else if (action instanceof MouseWheelAction) {
                this.mouseWheel((MouseWheelAction)action);
            } else if (action instanceof ScreenCaptureRequestAction) {
                this.screenCapture((ScreenCaptureRequestAction)action);
            } else if (action instanceof FileExploreRequestAction) {
                this.fileExplore((FileExploreRequestAction)action);
            } else if (action instanceof KeyboardAction) {
                this.keyboard((KeyboardAction)action);
            }
        } else {
            if (action instanceof AuthentificationAction) {
                this.authentificate((AuthentificationAction)action);
            }
            if (!this.authentificated) {
                try {
                    this.connection.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void authentificate(AuthentificationAction action) {
        if (action.password.equals(this.application.getPreferences().get("password", "azerty"))) {
            this.authentificated = true;
            this.application.getTrayIcon().notifyConnection(this.connection);
        }
        this.sendAction(new AuthentificationResponseAction(this.authentificated));
    }

    private void moveMouse(MouseMoveAction action) {
        Point mouseLocation;
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null && (mouseLocation = pointerInfo.getLocation()) != null) {
            int x = mouseLocation.x + action.moveX;
            int y = mouseLocation.y + action.moveY;
            this.application.getRobot().mouseMove(x, y);
        }
    }

    private void mouseClick(MouseClickAction action) {
        int button;
        switch (action.button) {
            case 1: {
                button = 16;
                break;
            }
            case 2: {
                button = 4;
                break;
            }
            case 3: {
                button = 8;
                break;
            }
            default: {
                return;
            }
        }
        if (action.state) {
            this.application.getRobot().mousePress(button);
        } else if (!action.state) {
            this.application.getRobot().mouseRelease(button);
        }
    }

    private void mouseWheel(MouseWheelAction action) {
        this.application.getRobot().mouseWheel(action.amount);
    }

    private void screenCapture(ScreenCaptureRequestAction action) {
        try {
            Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
            Rectangle r = new Rectangle(mouseLocation.x - action.width / 2, mouseLocation.y - action.height / 2, action.width, action.height);
            BufferedImage capture = new BufferedImage(1, 1, 12);
            if (r.width + r.height > 0) {
                capture = this.application.getRobot().createScreenCapture(r);
            }
            String format = null;
            if (action.format == 0) {
                format = "png";
            } else if (action.format == 1) {
                format = "jpg";
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)capture, format, baos);
            byte[] data = baos.toByteArray();
            this.sendAction(new ScreenCaptureResponseAction(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fileExplore(FileExploreRequestAction action) {
        if (action.directory.isEmpty() && action.file.isEmpty()) {
            this.fileExploreRoots();
        } else if (action.directory.isEmpty()) {
            this.fileExplore(new File(action.file));
        } else {
            File directory = new File(action.directory);
            if (directory.getParent() == null && action.file.equals("..")) {
                this.fileExploreRoots();
            } else {
                try {
                    this.fileExplore(new File(directory, action.file).getCanonicalFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.fileExploreRoots();
                }
            }
        }
    }

    private void fileExplore(File file) {
        block5: {
            block6: {
                Desktop desktop;
                block7: {
                    if (!file.exists() || !file.canRead()) break block6;
                    if (!file.isDirectory()) break block7;
                    this.sendFileExploreResponse(file.getAbsolutePath(), file.listFiles(), true);
                    break block5;
                }
                if (!Desktop.isDesktopSupported() || !(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) break block5;
                try {
                    desktop.open(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (!PRemoteDroidServerApp.IS_WINDOWS) break block5;
                    System.out.println("windows cmd fix");
                    try {
                        String line;
                        Process process = Runtime.getRuntime().exec("cmd /C " + file.getAbsolutePath());
                        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        while ((line = br.readLine()) != null) {
                            System.out.println(line);
                        }
                        break block5;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                break block5;
            }
            this.fileExploreRoots();
        }
    }

    private void fileExploreRoots() {
        String directory = "";
        File[] files = File.listRoots();
        this.sendFileExploreResponse(directory, files, false);
    }

    private void sendFileExploreResponse(String directory, File[] f, boolean parent) {
        if (f != null) {
            ArrayList<String> list = new ArrayList<String>();
            if (parent) {
                list.add("..");
            }
            int i = 0;
            while (i < f.length) {
                String name = f[i].getName();
                if (!name.isEmpty()) {
                    if (f[i].isDirectory()) {
                        name = String.valueOf(name) + File.separator;
                    }
                } else {
                    name = f[i].getAbsolutePath();
                }
                list.add(name);
                ++i;
            }
            String[] files = new String[list.size()];
            files = list.toArray(files);
            this.sendAction(new FileExploreResponseAction(directory, files));
        }
    }

    private void keyboard(KeyboardAction action) {
        if (this.useUnicodeWindowsAltTrick) {
            this.keyboardUnicodeWindowsAltTrick(action);
        } else {
            this.keyboardClassic(action);
        }
    }

    private void keyboardUnicodeWindowsAltTrick(KeyboardAction action) {
        boolean exception = false;
        int i = 0;
        while (i < UNICODE_EXCEPTION.length) {
            if (action.unicode == UNICODE_EXCEPTION[i][0]) {
                exception = true;
                this.application.getRobot().keyPress(UNICODE_EXCEPTION[i][1]);
                this.application.getRobot().keyRelease(UNICODE_EXCEPTION[i][1]);
                break;
            }
            ++i;
        }
        if (!exception) {
            PRemoteDroidServerConnection.pressUnicode(this.application.getRobot(), action.unicode);
        }
    }

    private void keyboardClassic(KeyboardAction action) {
        int keycode = UnicodeToSwingKeyCodeConverter.convert(action.unicode);
        if (keycode != -1) {
            System.out.println("Now pressing key of code: " + keycode);
            boolean useShift = UnicodeToSwingKeyCodeConverter.useShift(action.unicode);
            if (useShift) {
                this.application.getRobot().keyPress(16);
            }
            this.application.getRobot().keyPress(keycode);
            this.application.getRobot().keyRelease(keycode);
            if (useShift) {
                this.application.getRobot().keyRelease(16);
            }
        } else {
            PRemoteDroidServerConnection.pressUnicode(this.application.getRobot(), action.unicode);
        }
    }

    public static void pressUnicode(Robot r, int key_code) {
        r.keyPress(18);
        boolean useHexKeypad = false;
        if (!useHexKeypad) {
            String s = String.format("%04d", key_code);
            System.out.println("Now pressing key of dec unicode: " + s);
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                int keycode = c - 48 + 96;
                r.keyPress(keycode);
                r.keyRelease(keycode);
                ++i;
            }
        } else {
            String s = Integer.toHexString(key_code);
            System.out.println("Now pressing key of hex unicode: " + s);
            r.keyPress(107);
            r.keyRelease(107);
            int i = 0;
            while (i < s.length()) {
                int keycode = UnicodeToSwingKeyCodeConverter.convert(s.charAt(i));
                r.keyPress(keycode);
                r.keyRelease(keycode);
                ++i;
            }
        }
        r.keyRelease(18);
    }

    private void sendAction(PRemoteDroidAction action) {
        try {
            this.connection.sendAction(action);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

