/*
 * Decompiled with CFR 0.152.
 */
package org.pierre.remotedroid.protocol.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.pierre.remotedroid.protocol.PRemoteDroidConnection;

public class PRemoteDroidConnectionTcp
extends PRemoteDroidConnection {
    public static final int DEFAULT_PORT = 64788;
    private Socket socket;

    public PRemoteDroidConnectionTcp(Socket socket) throws IOException {
        super(socket.getInputStream(), socket.getOutputStream());
        this.socket = socket;
        this.socket.setPerformancePreferences(0, 2, 1);
        this.socket.setTcpNoDelay(true);
        this.socket.setReceiveBufferSize(0x100000);
        this.socket.setSendBufferSize(0x100000);
    }

    public static PRemoteDroidConnectionTcp create(String host, int port) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(host, port), 1000);
        PRemoteDroidConnectionTcp connection = new PRemoteDroidConnectionTcp(socket);
        return connection;
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public void close() throws IOException {
        this.socket.shutdownInput();
        this.socket.shutdownOutput();
        super.close();
        this.socket.close();
    }
}

