/*
 * Decompiled with CFR 0.152.
 */
package org.pierre.remotedroid.protocol.action;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import org.pierre.remotedroid.protocol.action.AuthentificationAction;
import org.pierre.remotedroid.protocol.action.AuthentificationResponseAction;
import org.pierre.remotedroid.protocol.action.FileExploreRequestAction;
import org.pierre.remotedroid.protocol.action.FileExploreResponseAction;
import org.pierre.remotedroid.protocol.action.KeyboardAction;
import org.pierre.remotedroid.protocol.action.MouseClickAction;
import org.pierre.remotedroid.protocol.action.MouseMoveAction;
import org.pierre.remotedroid.protocol.action.MouseWheelAction;
import org.pierre.remotedroid.protocol.action.ScreenCaptureRequestAction;
import org.pierre.remotedroid.protocol.action.ScreenCaptureResponseAction;

public abstract class PRemoteDroidAction {
    public static final byte MOUSE_MOVE = 0;
    public static final byte MOUSE_CLICK = 1;
    public static final byte MOUSE_WHEEL = 2;
    public static final byte KEYBOARD = 3;
    public static final byte AUTHENTIFICATION = 4;
    public static final byte AUTHENTIFICATION_RESPONSE = 5;
    public static final byte SCREEN_CAPTURE_REQUEST = 6;
    public static final byte SCREEN_CAPTURE_RESPONSE = 7;
    public static final byte FILE_EXPLORE_REQUEST = 8;
    public static final byte FILE_EXPLORE_RESPONSE = 9;

    public static PRemoteDroidAction parse(DataInputStream dis) throws IOException {
        byte type = dis.readByte();
        switch (type) {
            case 0: {
                return MouseMoveAction.parse(dis);
            }
            case 1: {
                return MouseClickAction.parse(dis);
            }
            case 2: {
                return MouseWheelAction.parse(dis);
            }
            case 3: {
                return KeyboardAction.parse(dis);
            }
            case 4: {
                return AuthentificationAction.parse(dis);
            }
            case 5: {
                return AuthentificationResponseAction.parse(dis);
            }
            case 6: {
                return ScreenCaptureRequestAction.parse(dis);
            }
            case 7: {
                return ScreenCaptureResponseAction.parse(dis);
            }
            case 8: {
                return FileExploreRequestAction.parse(dis);
            }
            case 9: {
                return FileExploreResponseAction.parse(dis);
            }
        }
        throw new ProtocolException();
    }

    public static PRemoteDroidAction parse(DataInputStream dis, byte type) throws IOException {
        switch (type) {
            case 0: {
                return MouseMoveAction.parse(dis);
            }
            case 1: {
                return MouseClickAction.parse(dis);
            }
            case 2: {
                return MouseWheelAction.parse(dis);
            }
            case 3: {
                return KeyboardAction.parse(dis);
            }
            case 4: {
                return AuthentificationAction.parse(dis);
            }
            case 5: {
                return AuthentificationResponseAction.parse(dis);
            }
            case 6: {
                return ScreenCaptureRequestAction.parse(dis);
            }
            case 7: {
                return new ScreenCaptureResponseAction(new byte[0]);
            }
            case 8: {
                return FileExploreRequestAction.parse(dis);
            }
            case 9: {
                return FileExploreResponseAction.parse(dis);
            }
        }
        return new ScreenCaptureResponseAction(new byte[0]);
    }

    public abstract void toDataOutputStream(DataOutputStream var1) throws IOException;
}

